<?php
include_once "inc/user_data.php";
$app = new controller;
?>
<!doctype html>
<html lang="en">
<head>
    <title>All Account Management</title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge, chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">
    <!-- VENDOR CSS -->
    <link rel="stylesheet" href="assets/vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/vendor/font-awesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="assets/vendor/jquery-datatable/dataTables.bootstrap4.min.css">
    <link rel="stylesheet" href="assets/vendor/jquery-datatable/fixedeader/dataTables.fixedcolumns.bootstrap4.min.css">
    <link rel="stylesheet" href="assets/vendor/jquery-datatable/fixedeader/dataTables.fixedheader.bootstrap4.min.css">
    <link rel="stylesheet" href="assets/vendor/sweetalert/sweetalert.css"/>
    <link rel="stylesheet" href="assets/vendor/toastr/toastr.min.css">
    <!-- MAIN CSS -->
    <link rel="stylesheet" href="assets/css/main.css">
    <link rel="stylesheet" href="assets/css/color_skins.css">
    <style>
        td.details-control {
            background: url('assets/images/details_open.png') no-repeat center center;
            cursor: pointer;
        }

        tr.shown td.details-control {
            background: url('assets/images/details_close.png') no-repeat center center;
        }
    </style>
</head>

<body class="theme-blue">

<!-- Page Loader -->
<div class="page-loader-wrapper">

</div>
<!-- Overlay For Sidebars -->

<div id="wrapper">

    <?php
    include_once "inc/header.php";
    ?>

    <?php
    include_once "inc/sidebar.php";
    ?>

    <div id="main-content">
        <div class="container-fluid">
            <div class="block-header">
                <div class="row">
                    <div class="col-lg-5 col-md-8 col-sm-12">
                        <h2><a href="" class="btn btn-xs btn-link btn-toggle-fullwidth"><i
                                        class="fa fa-arrow-left"></i></a> Account Management</h2>
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href="dashboard"><i class="fa fa-home fa-lg"></i></a></li>
                            <li class="breadcrumb-item active">Account Setup</li>
                        </ul>
                    </div>
                    <div class="col-lg-7 col-md-4 col-sm-12 text-right">
                        <div class="inlineblock text-center m-r-15 m-l-15 hidden-sm">

                        </div>
                        <div class="inlineblock text-center m-r-15 m-l-15 hidden-sm">

                        </div>
                    </div>
                </div>
            </div>

            <div class="row clearfix">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="header">
                            <a href="add_bank.php">
                                <button class="fa-pull-left btn btn-primary m-l-30">Add Account</button>
                            </a>
                            <button class="fa-pull-right btn btn-primary m-l-30 font-weight-bold" data-toggle="modal"
                                    data-target="#cvde">
                                Refund Customer
                            </button>
                            <br>
                        </div>

                        <div class="body">

                            <div class="table-responsive">
                                <table class="table table-striped table-hover js-basic-example dataTable table-custom">
                                    <thead>
                                    <tr>
                                        <th>SN</th>
                                        <th>Account Name</th>
                                        <th>Account No</th>
                                        <th>Balance</th>
                                        <th>Created Date</th>
                                        <th>Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                    // $sort = 2;
                                    $get_total_info = $app->banks();
                                    //var_dump($get_total_info);
                                    $sn = 0;
                                    foreach ($get_total_info as $key => $values) {
                                        $sn++;
                                        ?>
                                        <tr class="dn_<?= $values->id; ?>">
                                            <td><?= $sn; ?></td>
                                            <td><?= $values->bank_name; ?></td>
                                            <td><?= $values->account_no; ?></td>
                                            <td><?= number_format($values->bal, 2); ?></td>
                                            <td><?= $values->date_created; ?></td>
                                            <td>
                                                <div class="btn-group" role="group">
                                                    <button id="btnGroupDrop1" type="button"
                                                            class="btn btn-primary dropdown-toggle"
                                                            data-toggle="dropdown" aria-haspopup="true"
                                                            aria-expanded="false">
                                                        Action
                                                    </button>
                                                    <div class="dropdown-menu" aria-labelledby="btnGroupDrop1"
                                                         x-placement="top-start"
                                                         style="position: absolute; transform: translate3d(0px, -2px, 0px); top: 0px; left: 0px; will-change: transform;">
                                                        <a class="dropdown-item"
                                                           href="edit_banks.php?sid=<?= base64_encode($values->id); ?>">Edit</a>
                                                        <a class="dropdown-item"
                                                           href="add_expenses_info_bank.php?sid=<?= base64_encode($values->id); ?>&&bank_names=<?= $values->bank_name; ?>&&bal=<?= base64_encode($values->bal); ?>">Send
                                                            Funds to expenses acc</a>
                                                        <a class="dropdown-item"
                                                           href="inter_transfer.php?sid=<?= base64_encode($values->id); ?>&&bank_names=<?= $values->bank_name; ?>&&bal=<?= base64_encode($values->bal); ?>">Inter
                                                            Account Transfer</a>
                                                        <hr>
                                                        <a class="dropdown-item del_staff_remove"
                                                           data-id="<?= $values->id; ?>"
                                                           data-fullname="<?= $values->bank_name; ?>"
                                                           data-nb="dn_<?= $values->id; ?>">Delete</a>
                                                    </div>
                                                </div>

                                            </td>
                                        </tr>
                                        <?php
                                    }
                                    ?>
                                    </tbody>

                                </table>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

</div>

<!-- Javascript -->
<script src="assets/bundles/libscripts.bundle.js"></script>
<script src="assets/bundles/vendorscripts.bundle.js"></script>

<script src="assets/bundles/datatablescripts.bundle.js"></script>
<script src="assets/vendor/jquery-datatable/buttons/dataTables.buttons.min.js"></script>
<script src="assets/vendor/jquery-datatable/buttons/buttons.bootstrap4.min.js"></script>
<script src="assets/vendor/jquery-datatable/buttons/buttons.colVis.min.js"></script>
<script src="assets/vendor/jquery-datatable/buttons/buttons.html5.min.js"></script>
<script src="assets/vendor/jquery-datatable/buttons/buttons.print.min.js"></script>

<script src="assets/vendor/sweetalert/sweetalert.min.js"></script> <!-- SweetAlert Plugin Js -->
<script src="assets/vendor/toastr/toastr.js"></script>
<script src="assets/bundles/mainscripts.bundle.js"></script>
<script src="assets/js/pages/tables/jquery-datatable.js"></script>
<script>
    $(document).ready(function () {

        // $(".del_staff_remove").click(function () {
            $(document).on('click', '.del_staff_remove', function () {
            const uid = $(this).attr("data-id");
            const wc = $(this).attr("data-fullname");
            const sb = $(this).attr("data-nb");
            // show in text field
            $("#uid").val(uid);
            $("#fullname").val(wc);
            $("#sb").val(sb);
            //display modal
            $('#del_staff').modal('show');

            $("#del_stf").click(function () {
                const uid = $("#uid").val();
                const sb = $("#sb").val();
                const btn = $("#del_stf");
                btn.attr('disabled', true).html('<i class="fa fa-spin fa-spinner"></i> Deleting...');
                //validate
                //call Ajax
                if (uid === '' || uid === 0) {
                    toastr.warning('Please check selection.', 'warning');
                    const btn = $("#del_stf");
                    btn.attr('disabled', false).html('<i class="fa fa-spin fa-spinner"></i> Try Again...');
                } else {
                    $.ajax({
                        url: "ajax/del_banks.php",
                        method: "GET",
                        data: {
                            uid: uid
                        },
                        success: function (data) {
                            if (data.trim() == 'done') {
                                toastr.success('The Work Bank has been removed.', 'Success');
                                let cc = '.' + sb;
                                $(cc).hide();
                                btn.attr('disabled', false).html('Delete Wc');
                                $('#del_staff').modal('hide');
                            }
                        }
                    });
                }
            });
        });
    })
</script>
<script>
    $(document).ready(function () {
        $('select').selectize({
            sortField: 'text'
        });
    });
</script>

<script>
    $(document).ready(function () {
        /* function to login user */
        $("#submitForm234").on('submit', (function (e) {
            e.preventDefault();
            var btn = $("#reset-b");
            btn.attr('disabled', true).html("<i class='fa fa-spin fa-spinner'></i> processing");
            var datas = new FormData(this);
            $.ajax({
                url: "ajax/bank_to_customer",
                type: "POST",
                data: datas,
                contentType: false,
                cache: false,
                processData: false,
                success: (data) => {
                    alert(data)
                    toastr.success('Transfer Completed!.', 'Success');
                    setTimeout(
                        function () {
                            location.reload();
                        }, 3000);
                },

            });
        }));

    });
</script>

</body>
</html>
<!--delete staff-->
<div class="modal fade" id="del_staff" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h6 class="title font-weight-bold" id="defaultModalLabel">Delete Bank Account</h6>
            </div>
            <span class="m-l-10 text-danger">Please note this action is permanent</span>
            <div class="modal-body">
                <div class="row clearfix">
                    <div class="col-6">
                        <div class="form-group">
                            <input type="text" class="form-control font-weight-bold" id="fullname"
                                   placeholder="" readonly>
                        </div>
                    </div>
                    <div class="col-12">
                        <input type="hidden" id="uid">
                        <input type="hidden" id="sb">
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" id="del_stf" class="btn btn-primary font-weight-bold">Delete Bank</button>
                <button type="button" class="btn btn-danger font-weight-bold" data-dismiss="modal">X</button>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="cvde" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h6 class="title font-weight-bold" id="defaultModalLabel">Send Funds To Customer Account</h6>
            </div>
            <span class="m-l-10 text-danger">Please note this action can be changed</span>

            <form method="POST" id="submitForm234">
                <div class="modal-body">
                    <div class="row clearfix">
                        <div class="col-10">
                            <div class="form-group">
                                <label>Enter Amount</label>
                                <input type="number" class="form-control font-weight-bold" name="amount"
                                       placeholder="" required>
                            </div>
                            <div class="form-group">
                                <label>Transfer Description</label>
                                <input type="text" class="form-control font-weight-bold" name="de"
                                       placeholder="description" required>
                            </div>

                            <div class="form-group">
                                <label>Choose Bank </label>
                                <select class="form-control" name="bank_id" required>
                                    <option value="">Choose Bank</option>
                                    <?php
                                    $get_total_info = $app->banks();
                                    foreach ($get_total_info as $key => $values) {
                                        ?>
                                        <option value="<?= $values->id; ?>"><?= $values->bank_name; ?></option>
                                        <?php
                                    }
                                    ?>
                                </select>
                            </div>

                            <div class="form-group">
                                <label>Choose Customer</label>
                                <select name="cus_id" class="form-control" required id="select-state"
                                        placeholder="Pick a account..." style="width: 100%">
                                    <option value="">Choose Account</option>
                                    <?php
                                    $get_total_info = $app->customer_data();
                                    $sn = 0;
                                    foreach ($get_total_info as $key => $values) {
                                        ?>
                                        <option value="<?= $values->id; ?>"><?= $values->c_name; ?></option>
                                        <?php
                                    }
                                    ?>
                                </select>
                            </div>

                            <div class="form-group">
                                <label>Transaction Date</label>
                                <input type="datetime-local" class="form-control font-weight-bold" name="tdate"
                                       placeholder="Transaction" required>
                            </div>


                        </div>
                        <div class="col-12">
                            <input type="hidden" id="uid">
                            <input type="hidden" id="sb">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <!--                <button type="button" id="cash_vot" class="btn btn-primary font-weight-bold">Transfer</button>-->

                    <input type="submit"
                           class="font-weight-bold btn btn-primary btn-outline btn-rounded pull-right"
                           value="Transfer" id="reset-b">

                    <button type="button" class="btn btn-danger font-weight-bold" data-dismiss="modal">X</button>
                </div>
        </div>
        </form>


    </div>
</div>
