<?php
include_once "inc/user_data.php";
$app = new controller;
$rtype = $app->get_request('rtype');

$sdate = $app->get_request('sdate');

$edate = $app->get_request('edate');

$s = date("Y-m-d H:i:s", strtotime($sdate));
$e = date("Y-m-d H:i:s", strtotime($edate));

$principal_report = $app->cr_bank_acc_s($rtype,$s,$e);
$principal_reports = $app->dr_bank_acc_s($rtype,$s,$e);

$get_work_bank = $app->get_work_bank($rtype);
?>
<!doctype html>
<html lang="en">
<head>
    <title>Loan Management</title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge, chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">
    <!-- VENDOR CSS -->
    <link rel="stylesheet" href="assets/vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/vendor/font-awesome/css/font-awesome.min.css">

    <link rel="stylesheet" href="assets/vendor/jquery-datatable/dataTables.bootstrap4.min.css">
    <link rel="stylesheet" href="assets/vendor/jquery-datatable/fixedeader/dataTables.fixedcolumns.bootstrap4.min.css">
    <link rel="stylesheet" href="assets/vendor/jquery-datatable/fixedeader/dataTables.fixedheader.bootstrap4.min.css">
    <link rel="stylesheet" href="assets/vendor/sweetalert/sweetalert.css"/>
    <link rel="stylesheet" href="assets/vendor/toastr/toastr.min.css">

    <!-- MAIN CSS -->
    <link rel="stylesheet" href="assets/css/main.css">
    <link rel="stylesheet" href="assets/css/color_skins.css">
    <style>
        td.details-control {
            background: url('assets/images/details_open.png') no-repeat center center;
            cursor: pointer;
        }

        tr.shown td.details-control {
            background: url('assets/images/details_close.png') no-repeat center center;
        }
    </style>
    <!-- Print styles. -->
    <style type="text/css" media="print">

        div#DivIdToPrint {
            display: inline ;
        }

    </style>
</head>

<body class="theme-blue">

<!-- Page Loader -->
<div class="page-loader-wrapper">
    <div class="loader">
        <div class="m-t-30"><img src="logo.png" width="48" height="48" alt="Daros"></div>
        <p>Please wait...</p>
    </div>
</div>
<!-- Overlay For Sidebars -->

<div id="wrapper">

    <?php
    include_once "inc/header.php";
    ?>

    <?php
    include_once "inc/sidebar.php";
    ?>

    <div id="main-content">
        <div class="container-fluid">
            <div class="block-header">
                <div class="row">
                    <div class="col-lg-5 col-md-8 col-sm-12">
                        <h2><a href="javascript:void(0);" class="btn btn-xs btn-link btn-toggle-fullwidth"><i
                                        class="fa fa-arrow-left"></i></a> Account Reports</h2>
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href="dashboard"><i class="fa fa-home fa-lg"></i></a></li>
                            <li class="breadcrumb-item active">Manage Loan</li>
                        </ul>
                    </div>
                    <div class="col-lg-7 col-md-4 col-sm-12 text-right">
                        <div class="inlineblock text-center m-r-15 m-l-15 hidden-sm">

                        </div>
                        <div class="inlineblock text-center m-r-15 m-l-15 hidden-sm">

                        </div>
                    </div>
                </div>
            </div>

            <div class="row clearfix">
                <div class="col-lg-12">
                    <div class="card" id="DivIdToPrint">
                        <div class="header">
                            <button class="fa-pull-right btn btn-primary m-l-30 font-weight-bold" id="ccv"
                                    onclick='printContent("DivIdToPrint");'>Print Report
                            </button>
                            <br>
                        </div>

                        <div class="card">
                            <div class="body w_user" style="font-weight: bold;color: black;font-size: 20px">
                                <img class="" src="logo.png" <img class="" src="logo.png"
                                                                  alt="" style="height: 111px;">
                                <div class="wid-u-info">
                                    <h5 style="text-transform: capitalize"><?= $get_work_bank->bank_name;  ?> / Reports </h5>
                                    <p class=" m-b-0" style="font-weight: bold;color: black">
                                        <br>From <?php echo $newDate = date("d-m-Y:h:i:s", strtotime($s)); ?> <span class="text-danger">To</span> <?php echo $newDate = date("d-m-Y:h:i:s", strtotime($e)); ?> </p>
                                </div>
                                <hr>
                                <div class="row">
                                    <div class="col-2" style="font-weight: bold;color: black">
                                        <small class="font-weight-bold" style="font-size: 15px">Total Debit </small>
                                        <h5 class="m-b-0"><span>  ₦<?= number_format($principal_reports->amountsx); ?></h5>

                                    </div>

                                    <div class="col-2" style="font-weight: bold;color: black">
                                        <small class="font-weight-bold" style="font-size: 15px">Total Credit</small>
                                        <h5 class="m-b-0">₦<?= number_format($principal_report->amounts); ?></h5>

                                    </div>


                                    <?php

                                $getlastbalnce = $app->getlastbalnce($edate,$rtype);
                                    foreach ($getlastbalnce as $lastbal){
                                        $last_balance=($lastbal->balance);
                                   }
?>

                                    <div class="col-2" style="font-weight: bold;color: black">
                                        <small class="font-weight-bold" style="font-size: 15px">Current Acc Balance for Period Review</small>
                                        <h5 class="m-b-0">₦<?= number_format($last_balance); ?></h5>

                                    </div>

                                    <div class="col-2">
                                        <small class="font-weight-bold" style="font-size: 15px">Printed On</small>
                                        <h5 class="m-b-0"><?php $get_date = date('Y-m-d H:i:s'); echo $newDate = date("d-m-Y:h:i:s", strtotime($get_date)); ?></h5>

                                    </div>

                                </div>
                            </div>
                        </div>

                        <div class="body">

                            <div class="table-responsive">
                                <table id="" class="table table-striped table-hover js-basic-examples dataTable table-custom">
                                    <thead>
                                    <tr style="font-weight: bold;color: black;font-size: 15px">
                                        <th style="width: 10px">SN</th>
                                       
                                        <th style="width: 30px">Posted Date</th>
                                        <th style="width: 30px">Value Date</th>
<!--                                        <th style="width: 30px">Value Date</th>-->
                                        <th style="max-width: 30px">Description</th>
                                        <th style="width: 30px">Debit</th>
                                        <th style="width: 30px">Credit</th>
                                        <th style="width: 30px">Balance</th>
                                    </tr>
                                    </thead>

                                    <tbody>
                                    <?php
//                                    $getlastbalnce = $app->getlastbalnce($s,$rtype);
//                                    foreach ($getlastbalnce as $lastbal){
//                                        $last_balance=($lastbal->balancex);
//                                    }
//                                    echo $last_balance;
//                                    $update_balances = $app->update_last_balances($rtype, $last_balance);

                                    $csdw = $app->opening_bank_statement($s,$rtype);
                                    foreach ($csdw as $cc){
                                    ?>
                                    <tr style="font-weight: bold;color: black;font-size: 15px">
                                        <th>-</th>
                                        <th>Opening Balance</th>
                                        <th><?php echo $newDate = date("d-m-Y:h:i:s", strtotime($cc->date_cr)); ?></th>
<!--                                        <th>--><?php //echo $newDates = date("d-m-Y:h:i:s", strtotime($cc->posted_dated)); ?><!--</th>-->
                                        <th>-</th>
                                        <th>₦<?= number_format($cc->balance);  ?></th>
                                        <th>₦0</th>
                                        <th>₦<?php
                                            echo number_format($cc->balance);
                                            }
                                            ?></th>
                                    </tr>
                                    <?php
                                    $get_bank_balance = $app->bank_infos($rtype);
                                      $cv =$cc->balance;
                                    //echo $cv = 0;
                                    $get_total_info = $app->banks_report_rc($rtype,$s,$e);
                                    $sn = 0;
                                    foreach ($get_total_info as $key => $values) {
                                        $sn++;
                                        if ($values->cr == 0) {
                                            $cv += $values->dr;
                                        } elseif($values->dr == 0) {
                                            $cv -=$values->cr;
                                        }

                                         //$add_new_student = $app->mode_banks($values->id, $cv);

                                        ?>
                                        <tr class="dn_<?= $values->id; ?>" style="font-weight: bold;color: black;font-size: 15px">
                                            <td><?= $sn; ?></td>
                                            <td><?php echo $newDate = date("d-m-Y:h:i:s", strtotime($values->posted_dated)); ?></td>
                                            <td><?php echo $newDate = date("d-m-Y:h:i:s", strtotime($values->date_cr)); ?></td>
<!--                                            <th>--><?php //echo $newDates = date("d-m-Y:h:i:s", strtotime($cc->posted_dated)); ?><!--</th>-->
                                        
                                            <td><?= $app->stringFormat($values->description,50); ?></td>

                                            <td>₦<?= number_format($values->dr); ?></td>
                                            <td>₦<?= number_format($values->cr); ?></td>
                                            <td>₦<?= number_format($cv,2); ?></td>
                                        </tr>
                                        <?php
                                    }
                                    ?>
                                    </tbody>
                                    <tr>
<!--                                        <th></th>-->
                                        <th></th>
                                        <th></th>
                                        <th></th>
                                        <th style="font-weight: bold;color: black">Total Transaction</th>
                                        <th style="font-weight: bold;color: black">Debit ₦<?= number_format($principal_reports->amountsx,2); ?></th>
                                        <th style="font-weight: bold;color: black">Credit ₦<?= number_format($principal_report->amounts,2); ?></th>

                                        <th></th>
                                    </tr>
                                </table>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

</div>

<!-- Javascript -->
<script src="assets/bundles/libscripts.bundle.js"></script>
<script src="assets/bundles/vendorscripts.bundle.js"></script>

<script src="assets/bundles/datatablescripts.bundle.js"></script>
<script src="assets/vendor/jquery-datatable/buttons/dataTables.buttons.min.js"></script>
<script src="assets/vendor/jquery-datatable/buttons/buttons.bootstrap4.min.js"></script>
<script src="assets/vendor/jquery-datatable/buttons/buttons.colVis.min.js"></script>
<script src="assets/vendor/jquery-datatable/buttons/buttons.html5.min.js"></script>
<script src="assets/vendor/jquery-datatable/buttons/buttons.print.min.js"></script>

<script src="assets/vendor/sweetalert/sweetalert.min.js"></script> <!-- SweetAlert Plugin Js -->
<script src="assets/vendor/toastr/toastr.js"></script>
<script src="assets/bundles/mainscripts.bundle.js"></script>
<script src="assets/js/pages/tables/jquery-datatable.js"></script>

<script>


    function printContent(el) {
        $("#ccv").hide();
        var restorepage = $('body').html();
        var printcontent = $('#' + el).clone();
        $('body').empty().html(printcontent);
        window.print();
        $('body').html(restorepage);
    }
</script>
</body>
</html>
