<?php
include_once "inc/user_data.php";
$app = new controller;
 $loan_ids = base64_decode($app->get_request('sid'));
 $loan_id = ($app->get_request('sid'));
$diff = $app->lite_plans($loan_ids);
?>
<!doctype html>
<html lang="en">
<head>
    <title>Loan Plans</title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge, chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">

    <link rel="icon" href="favicon.ico" type="image/x-icon">
    <!-- VENDOR CSS -->
    <link rel="stylesheet" href="assets/vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/vendor/font-awesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="assets/vendor/bootstrap-multiselect/bootstrap-multiselect.css">
    <link rel="stylesheet" href="assets/vendor/parsleyjs/css/parsley.css">
    <link rel="stylesheet" href="assets/vendor/toastr/toastr.min.css">
    <!-- MAIN CSS -->
    <link rel="stylesheet" href="assets/css/main.css">
    <link rel="stylesheet" href="assets/css/color_skins.css">
</head>
<body class="theme-cyan">
<!-- Page Loader -->
<div class="page-loader-wrapper">
    <!--    <div class="loader">-->
    <!--        <div class="m-t-30"><img src="assets/images/logo-icon.svg" width="48" height="48" alt="Lucid"></div>-->
    <!--        <p>Please wait...</p>-->
    <!--    </div>-->
</div>
<!-- Overlay For Sidebars -->
<div id="wrapper">
    <?php
    include_once "inc/header.php"
    ?>
    <?php
    include_once "inc/sidebar.php"
    ?>
    <div id="main-content">
        <div class="container-fluid">
            <div class="block-header">
                <div class="row">
                    <div class="col-lg-5 col-md-8 col-sm-12">
                        <h2><a href="javascript:void(0);" class="btn btn-xs btn-link btn-toggle-fullwidth"><i
                                        class="fa fa-arrow-left"></i></a>Loan Repayment plan Setup</h2>
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href=""><i class="icon-home"></i></a></li>
                            <li class="breadcrumb-item">Manage Setup</li>
                            <li class="breadcrumb-item active">Loan Profile</li>
                        </ul>
                    </div>
                    <div class="col-lg-7 col-md-4 col-sm-12 text-right">
                        <div class="inlineblock text-center m-r-15 m-l-15 hidden-sm">

                        </div>
                        <div class="inlineblock text-center m-r-15 m-l-15 hidden-sm">

                        </div>
                    </div>
                </div>
            </div>

            <div class="row clearfix">
                <div class="col-md-8">
                    <div class="card">
                        <div class="body">
                            <form id="basic-form" method="post" novalidate>
                                <div class="form-group">
                                    <label>Loan Id </label>
                                    <input type="text" class="form-control" readonly value="CLN<?=  ($loan_id); ?>">
                                </div>
                                <input type="hidden" value="<?=  base64_decode($loan_id); ?>" id="loanid" >

                                <div class="form-group">
                                    <label>Principal Amount</label>
                                    <input type="text" class="form-control" id="principal" value="<?= $diff->principal;  ?>">
                                </div>

                                <div class="form-group">
                                    <label>Interest Amount</label>
                                    <input type="text" class="form-control" id="interest" value="<?= $diff->interest;  ?>">
                                </div>

                                <div class="form-group">
                                    <label>Cheque Amount</label>
                                    <input type="text" class="form-control" id="camount" value="<?= $diff->cheque_amount; ?>">
                                </div>

                                <div class="form-group">
                                    <label>Repayment Description</label>
                                    <input type="text" class="form-control" id="description" value="<?= $diff->description; ?>">
                                </div>

                                <div class="form-group">
                                    <label>Valued Date </label>
                                    <input type="datetime-local" class="form-control" id="due_date" value="<?= $diff->interest_paid_date;  ?>">
                                </div>

                                <div class="form-group">
                                    <label>Posted Date </label>
                                    <input type="datetime-local" class="form-control" id="posted_date" value="<?= $diff->posted_dated;  ?>">
                                </div>


                                <div class="form-group">
                                    <label>Change Bank</label>
                                    <select id="cus_bankid" class="form-control">
                                        <option value="<?= $diff->bank_id;  ?>">Choose Bank</option>
                                        <?php
                                        $work_center = $app->banks();
                                        foreach ($work_center as $vals){
                                            ?>
                                            <option value="<?= $vals->id;  ?>"><?= $vals->bank_name;  ?></option>
                                            <?php
                                        }
                                        ?>
                                    </select>
                                </div>

                                <br>
                                <button type="button" class="btn btn-primary" id="update_plans">Update Settings</button>
                            </form>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </div>

</div>

<!-- Javascript -->
<script src="assets/bundles/libscripts.bundle.js"></script>
<script src="assets/bundles/vendorscripts.bundle.js"></script>

<script src="assets/vendor/bootstrap-multiselect/bootstrap-multiselect.js"></script>
<script src="assets/vendor/parsleyjs/js/parsley.min.js"></script>

<script src="assets/bundles/mainscripts.bundle.js"></script>
<script src="assets/vendor/toastr/toastr.js"></script>
<script>

    $(document).ready(function () {

        $("#update_plans").click(function () {
            const loan_id = $("#loanid").val();
            const principal = $("#principal").val();
            const interest = $("#interest").val();
            const due_date = $("#due_date").val();
            const posted_date = $("#posted_date").val();
            const camount = $("#camount").val();
            const cus_bankid = $("#cus_bankid").val();
            const description = $("#description").val();

            const btn = $("#del_stf");
            btn.attr('disabled', true).html('<i class="fa fa-spin fa-spinner"></i> Updating...');
            if (principal===0) {
                toastr.warning('Please check selection.', 'warning');
                const btn = $("#del_stf");
                btn.attr('disabled', false).html('<i class="fa fa-spin fa-spinner"></i> Try Again...');
            } else {
                $.ajax({
                    url: "ajax/edit_loanplans.php",
                    method: "GET",
                    data: {
                        loan_id: loan_id,principal:principal,interest:interest,due_date:due_date,camount:camount,cus_bankid:cus_bankid,posted_date:posted_date,description:description
                    },
                    success: function (data) {
                        // console.log(data);
                        if (data.trim() == 'done') {
                            toastr.success('Loan Plan Updated!.', 'Success');

                        }else{
                            toastr.error('Error in posting!.', 'Error');
                        }
                    }
                });
            }
        });



    });
</script>
</body>
</html>