<?php
include_once "inc/user_data.php";
$app = new controller;
$rtype = $app->get_request('bankid');

$sdate = $app->get_request('sdate');

$edate = $app->get_request('edate');

$s = date("Y-m-d H:i:s", strtotime($sdate));
$e = date("Y-m-d H:i:s", strtotime($edate));

$principal_report = $app->seh_amount($rtype, $s, $e);
$cinfo = $app->get_work_bank($rtype);


?>
<!doctype html>
<html lang="en">
<head>
    <title>Loan Management</title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge, chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">
    <!-- VENDOR CSS -->
    <link rel="stylesheet" href="assets/vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/vendor/font-awesome/css/font-awesome.min.css">

    <link rel="stylesheet" href="assets/vendor/jquery-datatable/dataTables.bootstrap4.min.css">
    <link rel="stylesheet" href="assets/vendor/jquery-datatable/fixedeader/dataTables.fixedcolumns.bootstrap4.min.css">
    <link rel="stylesheet" href="assets/vendor/jquery-datatable/fixedeader/dataTables.fixedheader.bootstrap4.min.css">
    <link rel="stylesheet" href="assets/vendor/sweetalert/sweetalert.css"/>
    <link rel="stylesheet" href="assets/vendor/toastr/toastr.min.css">

    <!-- MAIN CSS -->
    <link rel="stylesheet" href="assets/css/main.css">
    <link rel="stylesheet" href="assets/css/color_skins.css">
    <style>
        td.details-control {
            background: url('assets/images/details_open.png') no-repeat center center;
            cursor: pointer;
        }

        tr.shown td.details-control {
            background: url('assets/images/details_close.png') no-repeat center center;
        }
    </style>
</head>

<body class="theme-blue">

<!-- Page Loader -->
<div class="page-loader-wrapper">
    <div class="loader">
        <div class="m-t-30"><img src="assets/images/logo-icon.svg" width="48" height="48" alt="Lucid"></div>
        <p>Please wait...</p>
    </div>
</div>
<!-- Overlay For Sidebars -->

<div id="wrapper">
    <div id="printos">
        <?php
        include_once "inc/header.php";
        ?>

        <?php
        include_once "inc/sidebar.php";
        ?>
    </div>

    <div id="main-content">
        <div class="container-fluid">
            <div class="block-header">
                <div class="row">
                    <div class="col-lg-5 col-md-8 col-sm-12">
                        <h2><a href="javascript:void(0);" class="btn btn-xs btn-link btn-toggle-fullwidth"><i
                                        class="fa fa-arrow-left"></i></a>Schedule Reports </h2>
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href="dashboard"><i class="fa fa-home fa-lg"></i></a></li>
                            <li class="breadcrumb-item active">Schedule Loan</li>
                        </ul>
                    </div>
                    <div class="col-lg-7 col-md-4 col-sm-12 text-right">
                        <div class="inlineblock text-center m-r-15 m-l-15 hidden-sm">

                        </div>
                        <div class="inlineblock text-center m-r-15 m-l-15 hidden-sm">

                        </div>
                    </div>
                </div>
            </div>

            <div class="row clearfix">
                <div class="col-lg-12">
                    <div class="card" id="DivIdToPrint">
                        <div class="header">

                            <button class="fa-pull-right btn btn-primary m-l-30 font-weight-bold" id="ccv"
                                    onclick='printContent("DivIdToPrint");'>Print Report
                            </button>
                            <br>
                        </div>

                        <div class="card">
                            <div class="body w_user">
                                <img class="" src="logo.png"
                                     alt="">
                                <div class="wid-u-info">
                                    <h5>Schedule Reports / <?= $cinfo->bank_name; ?> / Acc
                                        No <?= $cinfo->account_no; ?> </h5>
                                    <p class="text-muted m-b-0">
                                        <br>From <?= $s; ?> <span class="text-danger">To</span> <?= $e; ?> </p>
                                </div>
                                <hr>
                                <div class="row">
                                    <div class="col-2">
                                        <h5 class="m-b-0">₦<?= number_format($principal_report->ccc); ?></h5>
                                        <small class="font-weight-bold" style="font-size: 15px">Grand Total</small>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="body">

                            <div class="table-responsive">
                                <table class="table table-striped table-hover js-basic-example dataTable table-custom">
                                    <thead>
                                    <tr>
                                        <th>SN</th>
                                        <th>Customer Names</th>
                                        <th>Due Date</th>
                                        <th>Loan Id</th>
                                        <th>Cheque Amount</th>
                                        <!--                                        <th>Action</th>-->
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                    $months = $app->getallDate();
                                    $check_month = $months->mdates;
                                    $get_total_info = $app->shedulesx($rtype, $s, $e);

                                    $sn = 0;
                                    foreach ($get_total_info as $key => $values) {
                                        $sn++;
                                        ?>
                                        <tr class="dn_<?= $values->id; ?>">
                                            <td><?= $sn; ?></td>
                                            <td><?= ($values->c_name); ?></td>
                                            <td><?= ($values->due_date); ?></td>
                                            <td>LC<?= ($values->id); ?></td>
                                            <td>₦<?= number_format($values->cheque_amount); ?></td>
                                        </tr>
                                        <?php
                                    }
                                    ?>
                                    </tbody>

                                </table>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

</div>

<!-- Javascript -->
<script src="assets/bundles/libscripts.bundle.js"></script>
<script src="assets/bundles/vendorscripts.bundle.js"></script>

<script src="assets/bundles/datatablescripts.bundle.js"></script>
<script src="assets/vendor/jquery-datatable/buttons/dataTables.buttons.min.js"></script>
<script src="assets/vendor/jquery-datatable/buttons/buttons.bootstrap4.min.js"></script>
<script src="assets/vendor/jquery-datatable/buttons/buttons.colVis.min.js"></script>
<script src="assets/vendor/jquery-datatable/buttons/buttons.html5.min.js"></script>
<script src="assets/vendor/jquery-datatable/buttons/buttons.print.min.js"></script>

<script src="assets/vendor/sweetalert/sweetalert.min.js"></script> <!-- SweetAlert Plugin Js -->
<script src="assets/vendor/toastr/toastr.js"></script>
<script src="assets/bundles/mainscripts.bundle.js"></script>
<script src="assets/js/pages/tables/jquery-datatable.js"></script>
<script>
    $(document).ready(function () {


    });
    function printContent(el) {
        $("#ccv").hide();
        var restorepage = $('body').html();
        var printcontent = $('#' + el).clone();
        $('body').empty().html(printcontent);
        window.print();
        $('body').html(restorepage);
    }
</script>
</body>
</html>
