<?php
include_once "inc/user_data.php";
$app = new controller;
?>
<!doctype html>
<html lang="en">
<head>
    <title>Add Staff</title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge, chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">

    <link rel="icon" href="favicon.ico" type="image/x-icon">
    <!-- VENDOR CSS -->
    <link rel="stylesheet" href="assets/vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/vendor/font-awesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="assets/vendor/bootstrap-multiselect/bootstrap-multiselect.css">
    <link rel="stylesheet" href="assets/vendor/parsleyjs/css/parsley.css">
    <link rel="stylesheet" href="assets/vendor/toastr/toastr.min.css">
    <!-- MAIN CSS -->
    <link rel="stylesheet" href="assets/css/main.css">
    <link rel="stylesheet" href="assets/css/color_skins.css">
</head>
<body class="theme-cyan">
<!-- Page Loader -->
<div class="page-loader-wrapper">
    <!--    <div class="loader">-->
    <!--        <div class="m-t-30"><img src="assets/images/logo-icon.svg" width="48" height="48" alt="Lucid"></div>-->
    <!--        <p>Please wait...</p>-->
    <!--    </div>-->
</div>
<!-- Overlay For Sidebars -->
<div id="wrapper">
    <?php
    include_once "inc/header.php"
    ?>
    <?php
    include_once "inc/sidebar.php"
    ?>
    <div id="main-content">
        <div class="container-fluid">
            <div class="block-header">
                <div class="row">
                    <div class="col-lg-5 col-md-8 col-sm-12">
                        <h2><a href="javascript:void(0);" class="btn btn-xs btn-link btn-toggle-fullwidth"><i
                                        class="fa fa-arrow-left"></i></a> Staff Management</h2>
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href="index.html"><i class="icon-home"></i></a></li>
                            <li class="breadcrumb-item">Add Staff</li>
                            <li class="breadcrumb-item active">Create New Staff</li>
                        </ul>
                    </div>
                    <div class="col-lg-7 col-md-4 col-sm-12 text-right">
                        <div class="inlineblock text-center m-r-15 m-l-15 hidden-sm">

                        </div>
                        <div class="inlineblock text-center m-r-15 m-l-15 hidden-sm">

                        </div>
                    </div>
                </div>
            </div>

            <div class="row clearfix">
                <div class="col-md-5">
                    <div class="card">

                        <div class="body">
                            <form id="basic-form" method="post" novalidate>
                                <div class="form-group">
                                    <label>Full Name </label>
                                    <input type="text" class="form-control" id="full_name" required>
                                </div>
                                <div class="form-group">
                                    <label>Position</label>
                                    <input type="text" class="form-control" id="position" required>
                                </div>
                                <div class="form-group">
                                    <label>Department</label>
                                    <input type="text" class="form-control" id="department" required>
                                </div>
                                <div class="form-group">
                                    <label>Email</label>
                                    <input type="email" class="form-control" id="email" required>
                                </div>

                                <div class="form-group">
                                    <label>Work Center </label>
                                    <select id="work_center" class="form-control">
                                        <option>Choose Work Center</option>
                                        <?php
                                        $work_center = $app->work_center();
                                        foreach ($work_center as $vals){
                                            ?>
                                            <option value="<?= $vals->id;  ?>"><?= $vals->center_name;  ?></option>
                                            <?php
                                        }
                                        ?>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label>Phone</label>
                                    <input type="text" class="form-control" id="phone" required>
                                </div>
                                <div class="form-group">
                                    <label>Address</label>
                                    <input type="text" class="form-control" id="address" required>
                                </div>

                                <div class="form-group">
                                    <label>Gender</label>
                                    <br/>
                                    <label class="fancy-radio">
                                        <input type="radio" id="gender" value="male" required
                                               data-parsley-errors-container="#error-radio">
                                        <span><i></i>Male</span>
                                    </label>
                                    <label class="fancy-radio">
                                        <input type="radio" id="gender" value="female">
                                        <span><i></i>Female</span>
                                    </label>
                                    <p id="error-radio"></p>
                                </div>

                                <br>
                                <button type="button" class="btn btn-primary" id="add_staff">Add Staff</button>
                            </form>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </div>

</div>

<!-- Javascript -->
<script src="assets/bundles/libscripts.bundle.js"></script>
<script src="assets/bundles/vendorscripts.bundle.js"></script>

<script src="assets/vendor/bootstrap-multiselect/bootstrap-multiselect.js"></script>
<script src="assets/vendor/parsleyjs/js/parsley.min.js"></script>

<script src="assets/bundles/mainscripts.bundle.js"></script>
<script src="assets/vendor/toastr/toastr.js"></script>
<script>

    $(document).ready(function () {

        $("#add_staff").click(function () {

            //form paras
            let fullname = $("#full_name").val();
            let postion_s = $("#position").val();
            let dpt = $("#department").val();
            let email = $("#email").val();
            let phone = $("#phone").val();
            let address = $("#address").val();
            let gender = $("#gender").val();
            let work_center = $("#work_center").val();

            //disable btn
            const btn = $("#add_staff");
            btn.attr('disabled', true).html('<i class="fa fa-spin fa-spinner"></i> Adding Staff...');
            //call Ajax
            if (fullname === '' || email === '') {
                toastr.warning('Please Add input.', 'warning');
                const btn = $("#add_staff");
                btn.attr('disabled', false).html('<i class="fa fa-spin fa-spinner"></i> Try Again...');
            } else {
                $.ajax({
                    url: "ajax/add_staff.php",
                    method: "GET",
                    data: {
                        fullname: fullname,
                        postion_s: postion_s,
                        dpt: dpt,
                        email: email,
                        phone: phone,
                        address: address,
                        gender: gender,
                        work_center:work_center
                    },
                    success: function (data) {

                        if (data.trim() == 'done') {
                            toastr.success('The Account has been saved.', 'Success');
                        }
                        //clr field
                        let fullname = $("#full_name").val("");
                        let postion_s = $("#position").val("");
                        let dpt = $("#department").val("");
                        let email = $("#email").val("");
                        let phone = $("#phone").val("");
                        let address = $("#address").val("");

                    }
                });

            }
        });


    });
</script>
</body>
</html>