<?php
include_once "inc/user_data.php";
$app = new controller;
 $sid = base64_decode($app->get_request('sid'));
 $sidc = $app->interestx($sid);
$cinfo = $app->edit_customer($sid);
?>
<!doctype html>
<html lang="en">
<head>
    <title>New Loan</title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge, chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">

    <link rel="icon" href="favicon.ico" type="image/x-icon">
    <!-- VENDOR CSS -->
    <link rel="stylesheet" href="assets/vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/vendor/font-awesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="assets/vendor/bootstrap-multiselect/bootstrap-multiselect.css">
    <link rel="stylesheet" href="assets/vendor/parsleyjs/css/parsley.css">
    <link rel="stylesheet" href="assets/vendor/toastr/toastr.min.css">
    <!-- MAIN CSS -->
    <link rel="stylesheet" href="assets/css/main.css">
    <link rel="stylesheet" href="assets/css/color_skins.css">
</head>
<body class="theme-cyan">
<!-- Page Loader -->
<div class="page-loader-wrapper">
    <!--    <div class="loader">-->
    <!--        <div class="m-t-30"><img src="assets/images/logo-icon.svg" width="48" height="48" alt="Lucid"></div>-->
    <!--        <p>Please wait...</p>-->
    <!--    </div>-->
</div>
<!-- Overlay For Sidebars -->
<div id="wrapper">
    <?php
    include_once "inc/header.php"
    ?>
    <?php
    include_once "inc/sidebar.php"
    ?>
    <div id="main-content">
        <div class="container-fluid">
            <div class="block-header">
                <div class="row">
                    <div class="col-lg-5 col-md-8 col-sm-12">
                        <h2><a href="javascript:void(0);" class="btn btn-xs btn-link btn-toggle-fullwidth"><i
                                        class="fa fa-arrow-left"></i></a> New Loan Setup</h2>
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href="index.html"><i class="icon-home"></i></a></li>
                            <li class="breadcrumb-item">Customer</li>
                            <li class="breadcrumb-item active">Loan</li>
                        </ul>
                    </div>
                    <div class="col-lg-7 col-md-4 col-sm-12 text-right">
                        <div class="inlineblock text-center m-r-15 m-l-15 hidden-sm">

                        </div>
                        <div class="inlineblock text-center m-r-15 m-l-15 hidden-sm">

                        </div>
                    </div>
                </div>
            </div>

            <div class="row clearfix">
                <div class="col-md-8">
                    <div class="card">

                        <div class="body">
                            <form id="basic-form" method="post" novalidate>
                                <div class="form-group">
                                    <label>Customer Name </label>
                                    <input type="text" id="cname" value="<?= $cinfo->c_name;  ?>" readonly class="form-control" id="" required>
                                </div>
                                <div class="form-group">
                                    <label>Loan Date </label>
                                    <input type="date"  class="form-control" id="loan_date" required>
                                </div>
                                <div class="form-group">
                                    <label>Loan Amount</label>
                                    <input type="text" class="form-control" id="amount" required>
                                </div>
                                <div class="form-group">
                                    <label>Due Date </label>
                                    <input type="date" class="form-control" id="due_date" required>
                                </div>

                                <div class="form-group">
                                    <label>Rate Type</label>
                                    <select id="rate" class="form-control">
                                        <option>Choose</option>
                                        <?php
                                        foreach ($sidc as $vals) {
                                            ?>
                                            <option value="<?= $vals->loans; ?>"><?= $vals->loans; ?></option>
                                            <?php
                                        }
                                        ?>
                                    </select>
                                </div>


                                <div class="form-group">
                                    <label>Loan Type</label>
                                    <select id="loan_type" class="form-control">
                                        <option>Regular</option>
                                        <option>Interest Free</option>
                                        <option>Others</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label>Surety Name</label>
                                    <input type="text" class="form-control" id="surety_name" required>
                                </div>

                                <div class="form-group">
                                    <label>Surety Work Address</label>
                                    <input type="email" class="form-control" id="surety_address" required>
                                </div>
                                <div class="form-group">
                                    <label>Surety Phone No</label>
                                    <input type="text" class="form-control" id="surety_phone" required>
                                </div>
                                <div class="form-group">
                                    <label>Surety Department</label>
                                    <input type="text" class="form-control" id="surety_dpt" required>
                                </div>

                                <div class="form-group">
                                    <label>Choose Loan Bank</label>
                                    <select id="bankid" class="form-control">
                                        <option>Choose Bank Account</option>
                                        <?php
                                        $work_center = $app->banks();
                                        foreach ($work_center as $vals){
                                            ?>
                                            <option value="<?= $vals->id;  ?>"><?= $vals->bank_name;  ?></option>
                                            <?php
                                        }
                                        ?>
                                    </select>
                                </div>


                                <div class="form-group">
                                    <label>Choose Customer Cheque Bank</label>
                                    <select id="cus_bankid" class="form-control">
                                        <option>Choose Bank</option>
                                        <?php
                                        $work_center = $app->banks();
                                        foreach ($work_center as $vals){
                                            ?>
                                            <option value="<?= $vals->id;  ?>"><?= $vals->bank_name;  ?></option>
                                            <?php
                                        }
                                        ?>
                                    </select>
                                </div>

                                <input type="hidden" value="<?= $sid; ?>" id="client">
                                <input type="hidden" value="<?= $cinfo->work_center; ?>" id="wc">

                                <br>
                                <button type="button" class="btn btn-primary" id="add_staff">Add Loan</button>
                            </form>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </div>

</div>

<!-- Javascript -->
<script src="assets/bundles/libscripts.bundle.js"></script>
<script src="assets/bundles/vendorscripts.bundle.js"></script>

<script src="assets/vendor/bootstrap-multiselect/bootstrap-multiselect.js"></script>
<script src="assets/vendor/parsleyjs/js/parsley.min.js"></script>

<script src="assets/bundles/mainscripts.bundle.js"></script>
<script src="assets/vendor/toastr/toastr.js"></script>
<script>

    $(document).ready(function () {

        $("#add_staff").click(function () {
            //form paras
            let loan_date = $("#loan_date").val();
            let amount = $("#amount").val();
            let due_date = $("#due_date").val();
            let loan_type = $("#loan_type").val();
            let rate = $("#rate").val();
            let surety_name = $("#surety_name").val();
            let surety_address = $("#surety_address").val();
            let surety_phone = $("#surety_phone").val();
            let surety_dpt = $("#surety_dpt").val();
            let client = $("#client").val();
            let bankid = $("#bankid").val();
            let cus_bankid = $("#cus_bankid").val();
            let wc = $("#wc").val();
            let cname = $("#cname").val();

            //disable btn
            const btn = $("#add_staff");
            btn.attr('disabled', true).html('<i class="fa fa-spin fa-spinner"></i> Adding Loan...');
            //call Ajax
            if (amount === 0 || surety_name === '') {
                toastr.warning('Please Add input.', 'warning');
                const btn = $("#add_staff");
                btn.attr('disabled', false).html('<i class="fa fa-spin fa-spinner"></i> Try Again...');
            } else {
                $.ajax({
                    url: "ajax/add_newloan.php",
                    method: "GET",
                    data: {
                        loan_date: loan_date,
                        amount: amount,
                        due_date: due_date,
                        loan_type: loan_type,
                        rate: rate,
                        surety_name: surety_name,
                        surety_phone: surety_phone,
                        surety_dpt: surety_dpt,
                        surety_address: surety_address,
                        client:client,
                        bankid:bankid,
                        wc:wc,
                        cus_bankid:cus_bankid,
                        cname:cname
                    },
                    success: function (data) {

                        if (data.trim() == 'done') {
                            toastr.success('Loan Created.', 'Success');
                        }
                    }
                });
            }
        });


    });
</script>
</body>
</html>