<?php
include_once "inc/user_data.php";
$app = new controller;
$loan_id = $app->get_request('sid');
$cus_sid = $app->get_request('cus_sid');
$bak_id = $app->get_request('bak_id');
$sname = base64_decode($app->get_request('sname'));
$get_loans = $app->get_loans($loan_id);
$edit_customer = $app->edit_customer($cus_sid);
$loanpaid_cus = $app->loanpaid_cus($loan_id);
$loanpaid_interest = $app->loanpaid_interest($loan_id);
?>
<!doctype html>
<html lang="en">
<head>
    <title>Loan Management</title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge, chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">
    <!-- VENDOR CSS -->
    <link rel="stylesheet" href="assets/vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/vendor/font-awesome/css/font-awesome.min.css">

    <link rel="stylesheet" href="assets/vendor/jquery-datatable/dataTables.bootstrap4.min.css">
    <link rel="stylesheet" href="assets/vendor/jquery-datatable/fixedeader/dataTables.fixedcolumns.bootstrap4.min.css">
    <link rel="stylesheet" href="assets/vendor/jquery-datatable/fixedeader/dataTables.fixedheader.bootstrap4.min.css">
    <link rel="stylesheet" href="assets/vendor/sweetalert/sweetalert.css"/>
    <link rel="stylesheet" href="assets/vendor/toastr/toastr.min.css">

    <!-- MAIN CSS -->
    <link rel="stylesheet" href="assets/css/main.css">
    <link rel="stylesheet" href="assets/css/color_skins.css">
    <style>
        td.details-control {
            background: url('assets/images/details_open.png') no-repeat center center;
            cursor: pointer;
        }

        tr.shown td.details-control {
            background: url('assets/images/details_close.png') no-repeat center center;
        }
    </style>
</head>

<body class="theme-blue">

<!-- Page Loader -->
<!--<div class="page-loader-wrapper">-->
<!--    <div class="loader">-->
<!--        <div class="m-t-30"><img src="assets/images/logo-icon.svg" width="48" height="48" alt="Lucid"></div>-->
<!--        <p>Please wait...</p>-->
<!--    </div>-->
<!--</div>-->
<!-- Overlay For Sidebars -->

<div id="wrapper">

    <?php
    include_once "inc/header.php";
    ?>

    <?php
    include_once "inc/sidebar.php";
    ?>

    <div id="main-content">
        <div class="container-fluid">
            <div class="block-header">
                <div class="row">
                    <div class="col-lg-5 col-md-8 col-sm-12">
                        <h2><a href="javascript:void(0);" class="btn btn-xs btn-link btn-toggle-fullwidth"><i
                                        class="fa fa-arrow-left"></i></a>Repayment Loan Management</h2>
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href="dashboard"><i class="fa fa-home fa-lg"></i></a></li>
                            <li class="breadcrumb-item active">Manage Loan</li>
                        </ul>
                    </div>
                    <div class="col-lg-7 col-md-4 col-sm-12 text-right">
                        <div class="inlineblock text-center m-r-15 m-l-15 hidden-sm">

                        </div>
                        <div class="inlineblock text-center m-r-15 m-l-15 hidden-sm">

                        </div>
                    </div>
                </div>
            </div>

            <div class="row clearfix">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="header">

                            <button class="fa-pull-right btn btn-primary m-l-30 font-weight-bold" id="addplans">Add
                                Repayment Schedule
                            </button>
                            <br>
                        </div>
                        <input type="hidden" value="<?= $loan_id; ?>" id="load_id">
                        <input type="hidden" value="<?= $cus_sid; ?>" id="cus_id">
                        <input type="hidden" value="<?= $bak_id; ?>" id="cus_bankid">

                        <div class="card">
                            <div class="body w_user">
                                <img class="rounded-circle" src="https://cdn-icons-png.flaticon.com/512/149/149071.png"
                                     alt="">
                                <div class="wid-u-info">
                                    <h5><?= $sname; ?></h5>
                                    <p class="text-muted m-b-0"><?= $edit_customer->center_name; ?>
                                        <br><?= $edit_customer->cphone; ?></p>
                                </div>
                                <hr>

                            </div>
                        </div>

                        <div class="body">

                            <div class="table-responsive">
                                <table class="table table-striped table-hover js-basic-example dataTable table-custom">
                                    <thead>
                                    <tr>
                                        <th>SN</th>
                                        <th>Loan Id</th>
                                        <th>Principal</th>
                                        <th>Interest</th>
                                        <th>Due Date</th>
                                        <th>Cheque Amount</th>
                                        <th>Interest Status</th>
                                        <th>Principal Status</th>
                                        <th>Interest Paid Date</th>
                                        <th>Principal Paid Date</th>
                                        <th>Accounts</th>
                                        <th>Payment Method</th>

                                        <th>Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                    $get_total_info = $app->loans_repayment($loan_id);
                                    $sn = 0;
                                    foreach ($get_total_info as $key => $values) {
                                        $sn++;
                                        ?>
                                        <tr class="dn_<?= $values->id; ?>">
                                            <td><?= $sn; ?></td>
                                            <td>Ln<?= $loan_id; ?></td>
                                            <td>₦<?= number_format($values->principal); ?></td>
                                            <td>₦<?= number_format($values->interest); ?></td>
                                            <td><?= $values->due_date; ?></td>
                                            <td>₦<?= number_format($values->cheque_amount); ?></td>
                                            <td style="text-transform: capitalize"><?= $values->interest_paid; ?></td>
                                            <td style="text-transform: capitalize"><?= $values->principal_paid; ?></td>
                                            <td><?= $values->interest_paid_date; ?></td>
                                            <td><?= $values->principal_paid_date; ?></td>
                                            <td><?= $values->bank_name; ?></td>
                                            <td><?= $values->method_pay; ?></td>
                                            <td>
                                                <div class="btn-group" role="group">
                                                    <button id="btnGroupDrop1" type="button"
                                                            class="btn btn-primary dropdown-toggle"
                                                            data-toggle="dropdown" aria-haspopup="true"
                                                            aria-expanded="false">
                                                        Action
                                                    </button>
                                                    <div class="dropdown-menu" aria-labelledby="btnGroupDrop1"
                                                         x-placement="top-start"
                                                         style="position: absolute; transform: translate3d(0px, -2px, 0px); top: 0px; left: 0px; will-change: transform;">
                                                        <?php
                                                        if ($values->interest_paid == 'paid' && $values->principal_paid == 'paid') {

                                                        }else{
                                                            echo' <a class="dropdown-item"
                                                           href="edit_loanplans.php?sid='. base64_encode($values->id).'">Edit
                                                            Plan</a>';
                                                        }
                                                        ?>

                                                        <hr>
                                                        <?php
                                                        if ($values->interest_paid == 'paid' && $values->principal_paid == 'paid') {

                                                        }else{
                                                            echo'<a class="dropdown-item delplans"
                                                           data-id="'.$values->id.'"
                                                           data-nb="dn_"'.$values->id.'">Delete</a>';
                                                        }
                                                        ?>

                                                    </div>
                                                </div>

                                            </td>
                                        </tr>
                                        <?php
                                    }
                                    ?>
                                    </tbody>

                                </table>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

</div>

<!-- Javascript -->
<script src="assets/bundles/libscripts.bundle.js"></script>
<script src="assets/bundles/vendorscripts.bundle.js"></script>

<script src="assets/bundles/datatablescripts.bundle.js"></script>
<script src="assets/vendor/jquery-datatable/buttons/dataTables.buttons.min.js"></script>
<script src="assets/vendor/jquery-datatable/buttons/buttons.bootstrap4.min.js"></script>
<script src="assets/vendor/jquery-datatable/buttons/buttons.colVis.min.js"></script>
<script src="assets/vendor/jquery-datatable/buttons/buttons.html5.min.js"></script>
<script src="assets/vendor/jquery-datatable/buttons/buttons.print.min.js"></script>

<script src="assets/vendor/sweetalert/sweetalert.min.js"></script> <!-- SweetAlert Plugin Js -->
<script src="assets/vendor/toastr/toastr.js"></script>
<script src="assets/bundles/mainscripts.bundle.js"></script>
<script src="assets/js/pages/tables/jquery-datatable.js"></script>
<script>
    $(document).ready(function () {

        $("#addplans").click(function () {
            const uid = $("#load_id").val();
            const cus_id = $("#cus_id").val();
            const cus_bankid = $("#cus_bankid").val();
            const btn = $("#del_stf");
            btn.attr('disabled', true).html('<i class="fa fa-spin fa-spinner"></i> Creating...');
            if (uid === 0) {
                toastr.warning('Please check selection.', 'warning');
                const btn = $("#del_stf");
                btn.attr('disabled', false).html('<i class="fa fa-spin fa-spinner"></i> Try Again...');
            } else {
                $.ajax({
                    url: "ajax/create_plans.php",
                    method: "GET",
                    data: {
                        uid: uid, cus_id: cus_id,cus_bankid:cus_bankid,
                    },
                    success: function (data) {
                        if (data.trim() == 'done') {
                            toastr.success('Loan Plan Created!.', 'Success');
                            location.reload();
                        }
                    }
                });
            }
        });

        $(".delplans").click(function () {
            const uid = $(this).attr("data-id");
            if (uid === 0) {
                toastr.warning('Please check selection.', 'warning');
            } else {
                $.ajax({
                    url: "ajax/del_loan_plan.php",
                    method: "GET",
                    data: {
                        uid: uid
                    },
                    success: function (data) {
                        if (data.trim() == 'done') {
                            toastr.success('Loan Plan Deleted!.', 'Success');
                            setTimeout(
                                function () {
                                    location.reload();
                                }, 3000);

                        }
                    }
                });
            }
        });


        $(".pay_loan").click(function () {
            const uid = $(this).attr("data-id");
            const loan_id = $(this).attr("data-loan_id");
            const amount = $(this).attr("data-amount");
            const cus = $(this).attr("data-cus");
            const bank = $(this).attr("data-bank");
            if (uid === 0) {
                toastr.warning('Please check selection.', 'warning');
            } else {
                $.ajax({
                    url: "ajax/pay_principal.php",
                    method: "GET",
                    data: {
                        uid: uid, loan_id: loan_id, amount: amount, cus: cus, bank: bank
                    },
                    success: function (data) {
                        console.log(data);
                        if (data.trim() == 'done') {
                            toastr.success('Loan Payment Updated!.', 'Success');
                            setTimeout(
                                function () {
                                    location.reload();
                                }, 3000);
                        }
                    }
                });
            }
        });


        $(".pay_interest").click(function () {
            const uid = $(this).attr("data-id");
            const loan_id = $(this).attr("data-loan_id");
            const amount = $(this).attr("data-amount");
            const cus = $(this).attr("data-cus");
            const bank = $(this).attr("data-bank");
            if (uid === 0) {
                toastr.warning('Please check selection.', 'warning');
            } else {
                $.ajax({
                    url: "ajax/pay_interest.php",
                    method: "GET",
                    data: {
                        uid: uid, loan_id: loan_id, amount: amount, cus: cus, bank: bank
                    },
                    success: function (data) {
                        if (data.trim() == 'done') {
                            toastr.success('Loan Payment Updated!.', 'Success');
                            setTimeout(
                                function () {
                                    location.reload();
                                }, 3000);
                        }
                    }
                });
            }
        });

        $(".pay_pri").click(function () {
            const uid = $(this).attr("data-id");
            const loan_id = $(this).attr("data-loan_id");
            const amount = $(this).attr("data-amount");
            const cus = $(this).attr("data-cus");
            const bank = $(this).attr("data-bank");
            if (uid === 0) {
                toastr.warning('Please check selection.', 'warning');
            } else {
                $.ajax({
                    url: "ajax/loan_principal.php",
                    method: "GET",
                    data: {
                        uid: uid, loan_id: loan_id, amount: amount, cus: cus, bank: bank
                    },
                    success: function (data) {
                        if (data.trim() == 'done') {
                            toastr.success('Loan Payment Updated!.', 'Success');
                            setTimeout(
                                function () {
                                    location.reload();
                                }, 3000);
                        }
                    }
                });
            }
        });

        $(".x_interest").click(function () {
            const uid = $(this).attr("data-id");
            const loan_id = $(this).attr("data-loan_id");
            const amount = $(this).attr("data-amount");
            const cus = $(this).attr("data-cus");
            const bank = $(this).attr("data-bank");
            if (uid === 0) {
                toastr.warning('Please check selection.', 'warning');
            } else {
                $.ajax({
                    url: "ajax/x_interest.php",
                    method: "GET",
                    data: {
                        uid: uid, loan_id: loan_id, amount: amount, cus: cus, bank: bank
                    },
                    success: function (data) {
                        console.log(data)
                        if (data.trim() == 'done') {
                            toastr.success('Loan Payment Updated!.', 'Success');
                            setTimeout(
                                function () {
                                    location.reload();
                                }, 3000);
                        }
                    }
                });
            }
        });

        $(".x_princiapl").click(function () {
            const uid = $(this).attr("data-id");
            const loan_id = $(this).attr("data-loan_id");
            const amount = $(this).attr("data-amount");
            const cus = $(this).attr("data-cus");
            const bank = $(this).attr("data-bank");
            if (uid === 0) {
                toastr.warning('Please check selection.', 'warning');
            } else {
                $.ajax({
                    url: "ajax/x_principal.php",
                    method: "GET",
                    data: {
                        uid: uid, loan_id: loan_id, amount: amount, cus: cus, bank: bank
                    },
                    success: function (data) {
                        console.log(data)
                        if (data.trim() == 'done') {
                            toastr.success('Loan Payment Updated!.', 'Success');
                            setTimeout(
                                function () {
                                    location.reload();
                                }, 3000);
                        }
                    }
                });
            }
        });


    });
</script>
</body>
</html>


<!--delete staff-->
<div class="modal fade" id="del_staff" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h6 class="title font-weight-bold" id="defaultModalLabel">Delete Staff</h6>
            </div>
            <span class="m-l-10 text-danger">Please note this action is permanent</span>
            <div class="modal-body">
                <div class="row clearfix">
                    <div class="col-6">
                        <div class="form-group">
                            <input type="text" class="form-control font-weight-bold" id="fullname"
                                   placeholder="" readonly>
                        </div>
                    </div>
                    <div class="col-12">
                        <input type="hidden" id="uid">
                        <input type="hidden" id="sb">
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" id="del_stf" class="btn btn-primary font-weight-bold">Delete Staff</button>
                <button type="button" class="btn btn-danger font-weight-bold" data-dismiss="modal">X</button>
            </div>
        </div>
    </div>
</div>