<?php
include_once "inc/user_data.php";
$app = new controller;
?>
<!doctype html>
<html lang="en">
<head>
    <title>Staff Report</title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge, chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">

    <link rel="icon" href="favicon.ico" type="image/x-icon">
    <!-- VENDOR CSS -->
    <link rel="stylesheet" href="assets/vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/vendor/font-awesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="assets/vendor/bootstrap-multiselect/bootstrap-multiselect.css">
    <link rel="stylesheet" href="assets/vendor/parsleyjs/css/parsley.css">
    <link rel="stylesheet" href="assets/vendor/toastr/toastr.min.css">
    <!-- MAIN CSS -->
    <link rel="stylesheet" href="assets/css/main.css">
    <link rel="stylesheet" href="assets/css/color_skins.css">
</head>
<body class="theme-cyan">
<!-- Page Loader -->
<div class="page-loader-wrapper">
        <div class="loader">
            <div class="m-t-30"><img src="assets/images/logo-icon.svg" width="48" height="48" alt="Lucid"></div>
            <p>Please wait...</p>
        </div>
</div>
<!-- Overlay For Sidebars -->
<div id="wrapper">
    <?php
    include_once "inc/header.php"
    ?>
    <?php
    include_once "inc/sidebar.php"
    ?>
    <div id="main-content">
        <div class="container-fluid">
            <div class="block-header">
                <div class="row">
                    <div class="col-lg-5 col-md-8 col-sm-12">
                        <h2><a href="javascript:void(0);" class="btn btn-xs btn-link btn-toggle-fullwidth"><i
                                        class="fa fa-arrow-left"></i></a> Today Reports</h2>
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href="index.html"><i class="icon-home"></i></a></li>
                            <li class="breadcrumb-item">Generate Report</li>
                            <li class="breadcrumb-item active">Query Info</li>
                        </ul>
                    </div>
                    <div class="col-lg-7 col-md-4 col-sm-12 text-right">
                        <div class="inlineblock text-center m-r-15 m-l-15 hidden-sm">

                        </div>
                        <div class="inlineblock text-center m-r-15 m-l-15 hidden-sm">

                        </div>
                    </div>
                </div>
            </div>

            <div class="row clearfix">

                <div class="col-md-5">
                    <div class="card">
                        <div class="body">
                            <h3>Generate Report</h3>
                            <form id="basic-form" method="get"  action="today_data.php">

                                <div class="form-group">
                                    <label>From </label>
                                    <input type="datetime-local" class="form-control"  name="sdate" required>
                                </div>

                                <div class="form-group">
                                    <label>To </label>
                                    <input type="datetime-local" class="form-control"  name="edate" required>
                                </div>

                                <br>
                                <input type="submit" class="btn btn-primary" id="" value="Run Report">
                            </form>
                        </div>
                    </div>
                </div>



            </div>

        </div>
    </div>

</div>

<!-- Javascript -->
<script src="assets/bundles/libscripts.bundle.js"></script>
<script src="assets/bundles/vendorscripts.bundle.js"></script>

<script src="assets/vendor/bootstrap-multiselect/bootstrap-multiselect.js"></script>
<script src="assets/vendor/parsleyjs/js/parsley.min.js"></script>

<script src="assets/bundles/mainscripts.bundle.js"></script>
<script src="assets/vendor/toastr/toastr.js"></script>
<script>

    $(document).ready(function () {
        // show when page load
        // toastr.info('Page Loaded!');
        $("#change_wc").click(function () {
            //form paras
            let wc = $("#wc").val();
            let work_center = $("#wc_code").val();
            let cus_id = $("#cus_id").val();

            //disable btn
            const btn = $("#change_wc");
            btn.attr('disabled', true).html('<i class="fa fa-spin fa-spinner"></i> Adding Work Center...');
            //call Ajax
            if (cus_id ===0) {
                toastr.warning('Please Add input.', 'warning');
                const btn = $("#change_wc");
                btn.attr('disabled', false).html('<i class="fa fa-spin fa-spinner"></i> Try Again...');
            } else {
                $.ajax({
                    url: "ajax/add_center.php",
                    method: "GET",
                    data: {
                        wc: wc,
                        work_center: work_center
                    },
                    success: function (data) {
                        console.log(data);
                        if (data.trim() == 'done') {
                            toastr.success('The Work Center has been added.', 'Success');
                            setTimeout(
                                function () {
                                    location.reload();
                                }, 3000);
                        }

                    }
                });

            }
        });


    });
</script>
</body>
</html>