<?php
include_once "inc/user_data.php";
$app = new controller;
$loans = new manage_loans;

$totalgiven_loans = $loans->cummulative_loans(0, 0);
$totalpaids_loans = $app->cummulative_paid(0, 0);
$all_customerr_loans_total = $app->all_customerr_loans_total();

$totalpaids_loans_test = $loans->loan_updated();
$totalgiven_loans_loans = $loans->totalgiven_loans();

// var_dump($totalpaids_loans_test);
?>
<!doctype html>
<html lang="en">
<head>
    <title>Loan Management</title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge, chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">
    <!-- VENDOR CSS -->
    <link rel="stylesheet" href="assets/vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/vendor/font-awesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css">


    <link rel="stylesheet" href="assets/vendor/sweetalert/sweetalert.css"/>
    <link rel="stylesheet" href="assets/vendor/toastr/toastr.min.css">

    <!-- MAIN CSS -->
    <link rel="stylesheet" href="assets/css/main.css">
    <link rel="stylesheet" href="assets/css/color_skins.css">
    <style>
        td.details-control {
            background: url('assets/images/details_open.png') no-repeat center center;
            cursor: pointer;
        }

        tr.shown td.details-control {
            background: url('assets/images/details_close.png') no-repeat center center;
        }
    </style>
</head>

<body class="theme-blue">

<!-- Page Loader -->
<!--<div class="page-loader-wrapper">-->
<!--    <div class="loader">-->
<!--        <div class="m-t-30"><img src="logo.png" width="48" height="48" alt="Daros"></div>-->
<!--        <p>Please wait...</p>-->
<!--    </div>-->
<!--</div>-->
<!-- Overlay For Sidebars -->

<div id="wrapper">

    <?php
    include_once "inc/header.php";
    ?>

    <?php
    include_once "inc/sidebar.php";
    ?>

    <div id="main-content">
        <div class="container-fluid">
            <div class="block-header">
                <div class="row">
                    <div class="col-lg-5 col-md-8 col-sm-12">
                        <h2><a href="javascript:void(0);" class="btn btn-xs btn-link btn-toggle-fullwidth"><i
                                        class="fa fa-arrow-left"></i></a> Loan Management</h2>
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href="dashboard"><i class="fa fa-home fa-lg"></i></a></li>
                            <li class="breadcrumb-item active">Manage Loan</li>
                        </ul>
                    </div>
                    <div class="col-lg-7 col-md-4 col-sm-12 text-right">
                        <div class="inlineblock text-center m-r-15 m-l-15 hidden-sm">

                        </div>
                        <div class="inlineblock text-center m-r-15 m-l-15 hidden-sm">

                        </div>
                    </div>
                </div>
            </div>

            <div class="row clearfix">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="header">
                            <a href="customer.php">
                                <button class="fa-pull-left btn btn-primary m-l-30">New Loan</button>
                            </a><br>
                           <br>
                            <h3>total given loan: <?php echo number_format($totalpaids_loans_test->loan_taken);  ?></h3>
                            
                            <br><h3>total paid loan: <?php echo number_format($totalpaids_loans_test->total_paid);   ?></h3>

                            <br><h3>total outstanding: <?php echo number_format($totalpaids_loans_test->balance);   ?></h3>
                           
                            
                            <br>
                        </div>

                        <div class="body">

                            <div class="table-responsive">
                                <table class="table table-striped table-hover js-basic-examples dataTables table-custom">
                                    <thead>
                                    <tr>
                                        <th>SN</th>
                                        <th>Loan Account</th>
                                        <th>Customer Name</th>
                                        <th>Loan Amount</th>
                                        <th>Principal Paid</th>
                                        <th>Interest Paid</th>
                                        <th>Balance</th>
                                        <th>Loan Type</th>
                                        <th>Rate</th>
                                        <th>Customer Bank </th>
                                        <th>Loan Bank </th>
                                        <th>Action</th>
                                    </tr>
                                    </thead>
                                    <tbody class="dexpenses">
                                    <?php

                                        //get the interest free loans account
                                        $fetch_interest_free = $app->get_interst_free();
                                        foreach($fetch_interest_free as $ifl){
                                             $close_loans = $app->update_repayment_ins($ifl->id);
                                        }

                                    $get_total_info = $loans->loans_datas();
                                    $sn = 0;
                                    foreach ($get_total_info as $key => $values) {
                                        $sn++;
                                         $bal=$values->loan_amount+$values->paid_principal_rev-$values->paid_principal;
                                         //get the loan type
                                         $loan_type = $values->loan_type;
                                         $new_loan_amt = $values->paid_principal_rev+$values->loan_amount;
                                         $rev = $values->paid_principal_rev;

                                        $add_new_student = $app->update_customer_loans($values->customer_id, $new_loan_amt, $values->paid_principal,$bal,$values->loan_type,$rev);

                                        if($values->loan_amount==$values->paid_principal){
                                            $close_loans = $app->close_loansed($values->customer_id);
                                        }

                                            if($values->paid_principal_rev>1){
                                                // close_loansedxxxx
                                               // echo $new_loan_amt;
                                                //echo $values->customer_id;
                                               // $close_loans = $app->close_loansedxxxx($values->customer_id,$new_loan_amt);
                                            }


                                        ?>
                                        <tr class="dn_<?= $values->customer_id; ?>" >
                                            <td><?= $sn; ?></td>
                                            <td>000<?= $values->customer_id; ?></td>
                                            <td><?php echo $values->c_name; ?></td>
                                            <td>₦<?= number_format($values->loan_amount+$values->revs); ?></td>
                                            <td>₦<?= number_format($values->paid_principal); ?></td>
                                            <td><?= number_format($values->interrest_paid); ?></td>
                                            <td>₦<?= number_format($values->loan_amount+$values->revs-$values->paid_principal); ?></td>
                                            <td><?= $values->loan_type; ?></td>
                                            <td><?= $values->rate; ?></td>
                                            <td><?= $values->bank_name; ?></td>
                                            <td><?= $values->bank_names; ?></td>
                                            <td>
                                                <div class="btn-group" role="group">
                                                    <button id="btnGroupDrop1" type="button"
                                                            class="btn btn-primary dropdown-toggle"
                                                            data-toggle="dropdown" aria-haspopup="true"
                                                            aria-expanded="false">
                                                        Action
                                                    </button>
                                                    <div class="dropdown-menu" aria-labelledby="btnGroupDrop1"
                                                         x-placement="top-start"
                                                         style="position: absolute; transform: translate3d(0px, -2px, 0px); top: 0px; left: 0px; will-change: transform;">
                                                        <a class="dropdown-item" href="edit_loan.php?sid=<?= base64_encode($values->id); ?>">Edit</a>

                                                        <a href="repayment_hist.php?sid=<?= $values->id; ?>&&cus_sid=<?= $values->customer_id; ?>&&sname=<?php echo base64_encode($values->c_name); ?>&&bak_id=<?=$values->cus_bankid;  ?>" class="dropdown-item disb" data-dis="<?= $values->id; ?>">Payment History</a>
                                                        <hr>
                                                        <a href="ajax/bd_debt.php?sid=<?= $values->customer_id; ?>" class="dropdown-item">Mark As Bad-Debt</a>
                                                        <hr>
                                                        <a href="repayment.php?sid=<?= $values->customer_id; ?>&&cus_sid=<?= $values->customer_id; ?>&&sname=<?php echo base64_encode($values->c_name); ?>&&bak_id=<?=$values->cus_bankid;  ?>" class="dropdown-item disb" data-dis="<?= $values->id; ?>">Payment Schedule</a>
                                                        <hr>
                                                        <a class="dropdown-item del_staff_remove"
                                                           data-id="<?= $values->id; ?>"
                                                           data-fullname="<?= $values->c_name; ?> (₦<?= number_format($values->loan_amount); ?>)" data-nb="dn_<?= $values->id; ?>" data-bank="<?= $values->bank_id; ?>" data-code="<?= $values->dcode; ?>" data-amount="<?= $values->loan_amount; ?>">Delete</a>
                                                    </div>
                                                </div>

                                            </td>
                                        </tr>
                                        <?php
                                    }
                                    ?>
                                    </tbody>

                                </table>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

</div>

<!-- Javascript -->
<script src="assets/bundles/libscripts.bundle.js"></script>
<script src="assets/bundles/vendorscripts.bundle.js"></script>

<script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>

<script src="assets/vendor/sweetalert/sweetalert.min.js"></script> <!-- SweetAlert Plugin Js -->
<script src="assets/vendor/toastr/toastr.js"></script>
<script src="assets/bundles/mainscripts.bundle.js"></script>
<script src="assets/js/pages/tables/jquery-datatable.js"></script>
<script>
    $(document).ready(function () {

            $(document).on('click', '.del_staff_remove', function() {
            const uid = $(this).attr("data-id");
            const fullname = $(this).attr("data-fullname");
            const bank = $(this).attr("data-bank");
            const code = $(this).attr("data-code");
            const amount = $(this).attr("data-amount");

            // var id = $(this).attr("id");
            const sb = $(this).attr("data-nb");
            // show in text field
            $("#uid").val(uid);
            $("#fullname").val(fullname);
            $("#sb").val(sb);
            //display modal
            $('#del_staff').modal('show');

            $("#del_stf").click(function () {
                const uid = $("#uid").val();
                const sb = $("#sb").val();
                const btn = $("#del_stf");
                btn.attr('disabled', true).html('<i class="fa fa-spin fa-spinner"></i> Deleting...');
                //validate
                //call Ajax
                if (uid === '' || uid === 0) {
                    toastr.warning('Please check selection.', 'warning');
                    const btn = $("#del_stf");
                    btn.attr('disabled', false).html('<i class="fa fa-spin fa-spinner"></i> Try Again...');
                } else {
                    $.ajax({
                        url: "ajax/del_loans.php",
                        method: "GET",
                        data: {
                            uid: uid,amount:amount,bank:bank,code:code
                        },
                        success: function (data) {
                            if (data.trim() == 'done') {
                                toastr.success('The Loan has been removed.', 'Success');
                                window.location.href = 'loans.php';
                                let cc = '.' + sb;
                                $(cc).hide();
                                btn.attr('disabled', false).html('Delete Loan');
                                $('#del_staff').modal('hide');
                            }
                        }
                    });

                }

            });

        });


        $(".disb").click(function () {
            const uid = $(this).attr("data-dis");
            // show in text field

            if (uid === '' || uid === 0) {
                toastr.warning('Please check selection.', 'warning');
            } else {
                $.ajax({
                    url: "ajax/ban_staff.php",
                    method: "GET",
                    data: {
                        uid: uid
                    },
                    success: function (data) {
                        console.log(data);
                        if (data.trim() == 'done') {
                            toastr.success('The Account has been Banned.', 'Success');
                            setTimeout(
                                function () {
                                    location.reload();
                                }, 3000);
                        }
                    }
                });
            }

        });


    })
</script>
</body>
</html>


<!--delete staff-->
<div class="modal fade" id="del_staff" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h6 class="title font-weight-bold" id="defaultModalLabel">Delete Loan</h6>
            </div>
            <span class="m-l-10 text-danger">Please note this action is permanent</span>
            <div class="modal-body">
                <div class="row clearfix">
                    <div class="col-6">
                        <div class="form-group">
                            <input type="text" class="form-control font-weight-bold" id="fullname"
                                   placeholder="" readonly>
                        </div>
                    </div>
                    <div class="col-12">
                        <input type="hidden" id="uid">
                        <input type="hidden" id="sb">
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" id="del_stf" class="btn btn-primary font-weight-bold">Delete Loan</button>
                <button type="button" class="btn btn-danger font-weight-bold" data-dismiss="modal">X</button>
            </div>
        </div>
    </div>
</div>