<?php
include_once "inc/user_data.php";
$app = new controller;
$sid = base64_decode($app->get_request('sid'));
$sidc = $app->edit_staffs($sid);

?>
<!doctype html>
<html lang="en">
<head>
    <title>Edit Staff</title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge, chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">

    <link rel="icon" href="favicon.ico" type="image/x-icon">
    <!-- VENDOR CSS -->
    <link rel="stylesheet" href="assets/vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/vendor/font-awesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="assets/vendor/bootstrap-multiselect/bootstrap-multiselect.css">
    <link rel="stylesheet" href="assets/vendor/parsleyjs/css/parsley.css">
    <link rel="stylesheet" href="assets/vendor/toastr/toastr.min.css">
    <!-- MAIN CSS -->
    <link rel="stylesheet" href="assets/css/main.css">
    <link rel="stylesheet" href="assets/css/color_skins.css">
</head>
<body class="theme-cyan">
<!-- Page Loader -->
<div class="page-loader-wrapper">
    <!--    <div class="loader">-->
    <!--        <div class="m-t-30"><img src="assets/images/logo-icon.svg" width="48" height="48" alt="Lucid"></div>-->
    <!--        <p>Please wait...</p>-->
    <!--    </div>-->
</div>
<!-- Overlay For Sidebars -->
<div id="wrapper">
    <?php
    include_once "inc/header.php"
    ?>
    <?php
    include_once "inc/sidebar.php"
    ?>
    <div id="main-content">
        <div class="container-fluid">
            <div class="block-header">
                <div class="row">
                    <div class="col-lg-5 col-md-8 col-sm-12">
                        <h2><a href="javascript:void(0);" class="btn btn-xs btn-link btn-toggle-fullwidth"><i
                                        class="fa fa-arrow-left"></i></a> Edit Management</h2>
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href="index.html"><i class="icon-home"></i></a></li>
                            <li class="breadcrumb-item">Edit Staff</li>
                            <li class="breadcrumb-item active">Modify Staff Info</li>
                        </ul>
                    </div>
                    <div class="col-lg-7 col-md-4 col-sm-12 text-right">
                        <div class="inlineblock text-center m-r-15 m-l-15 hidden-sm">

                        </div>
                        <div class="inlineblock text-center m-r-15 m-l-15 hidden-sm">

                        </div>
                    </div>
                </div>
            </div>

            <div class="row clearfix">
                <div class="col-md-12">
                    <div class="card">

                        <div class="body">
                            <form id="basic-form" method="post" novalidate>

                                <div class="form-group">
                                    <label>Full Name</label>
                                    <input type="text" class="form-control" id="full_name" value="<?= $sidc->fullname;  ?>"  required>
                                </div>


                                <div class="form-group">
                                    <label>Staff Position</label>
                                    <select id="position_x" class="form-control">
                                        <option value="<?= $sidc->position;  ?>"><?= $sidc->position_name;  ?></option>
                                        <?php
                                        $work_center = $app->staff_position();
                                        foreach ($work_center as $vals){
                                            ?>
                                            <option value="<?= $vals->id;  ?>"><?= $vals->position_name;  ?></option>
                                            <?php
                                        }
                                        ?>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label>Staff Department</label>
                                    <select id="dpt" class="form-control">
                                        <option value="<?= $sidc->department;  ?>"><?= $sidc->dpt;  ?></option>
                                        <?php
                                        $work_center = $app->staff_department_x();
                                        foreach ($work_center as $vals){
                                            ?>
                                            <option value="<?= $vals->id;  ?>"><?= $vals->dpt;  ?></option>
                                            <?php
                                        }
                                        ?>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label>Email</label>
                                    <input type="email" class="form-control" id="email" value="<?= $sidc->email;  ?>"  required>
                                </div>
                                <div class="form-group">
                                    <label>Phone</label>
                                    <input type="text" class="form-control" id="phone" value="<?= $sidc->phone;  ?>" required>
                                </div>
                                <div class="form-group">
                                    <label>Address</label>
                                    <input type="text" class="form-control" id="address" value="<?= $sidc->address;  ?>" required>
                                </div>

                                <div class="form-group">
                                    <label>Staff Gender</label>
                                    <select id="gender" class="form-control" style="text-transform: capitalize">
                                        <option style="text-transform: capitalize"><?= $sidc->gender; ?></option>
                                        <option>Male</option>
                                        <option>Female</option>
                                    </select>
                                </div>

                                <input type="hidden" value="<?= $sid; ?>" id="staff_id">

                                <div class="form-group">
                                    <label>Password***</label>
                                    <input type="text" class="form-control" id="pwd" value="<?= $sidc->password;  ?>" required>
                                </div>

                                <br>
                                <button type="button" class="btn btn-primary" id="add_staff">Update Staff</button>
                            </form>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </div>

</div>

<!-- Javascript -->
<script src="assets/bundles/libscripts.bundle.js"></script>
<script src="assets/bundles/vendorscripts.bundle.js"></script>

<script src="assets/vendor/bootstrap-multiselect/bootstrap-multiselect.js"></script>
<script src="assets/vendor/parsleyjs/js/parsley.min.js"></script>

<script src="assets/bundles/mainscripts.bundle.js"></script>
<script src="assets/vendor/toastr/toastr.js"></script>
<script>

    $(document).ready(function () {

        // show when page load
        $("#add_staff").click(function () {
            //form paras
            let fullname = $("#full_name").val();
            let postion_s = $("#position_x").val();
            let dpt = $("#dpt").val();
            let email = $("#email").val();
            let phone = $("#phone").val();
            let address = $("#address").val();
            let gender = $("#gender").val();
            let staff_id = $("#staff_id").val();
            let pwd = $("#pwd").val();

            //disable btn
            const btn = $("#add_staff");
            btn.attr('disabled', true).html('<i class="fa fa-spin fa-spinner"></i> Updating Staff...');
            //call Ajax
            if (fullname === '' || email === '') {
                toastr.warning('Please Add input.', 'warning');
                const btn = $("#add_staff");
                btn.attr('disabled', false).html('<i class="fa fa-spin fa-spinner"></i> Try Again...');
            } else {
                $.ajax({
                    url: "ajax/update_staffs.php",
                    method: "GET",
                    data: {
                        fullname: fullname,
                        postion_s: postion_s,
                        dpt: dpt,
                        email: email,
                        phone: phone,
                        address: address,
                        gender: gender,
                        staff_id:staff_id,
                        pwd:pwd
                    },
                    success: function (data) {

                        if (data.trim() == 'done') {
                            toastr.success('The Account has been Updated.', 'Success');
                            setTimeout(
                                function () {
                                    location.reload();
                                }, 3000);
                        }
                    }
                });

            }
        });


    });
</script>
</body>
</html>